/*
 * The org.opensourcephysics.display3d.simple3d package implements the
 * classes of the org.opensourcephysics.display3d package using
 * the so called painter's algorithm, in which the diferent parts of the
 * 3D scene are painted from back to front, thus achieving a simple, but
 * for many cases effective, hidden-line removal.
 *
 * Copyright (c) 2005  The Open Source Physics project
 *                     http://www.opensourcephysics.org
 */

package org.opensourcephysics.display3d.simple3d.utils;

/**
 * Some utility functions
 */
public class VectorAlgebra {

  static public double norm (Point3D u) {
    return Math.sqrt(u.x*u.x + u.y*u.y + u.z*u.z);
  }

  static public Point3D crossProduct (Point3D u, Point3D v) {
    return new Point3D (u.y*v.z - u.z*v.y, u.z*v.x - u.x*v.z, u.x*v.y - u.y*v.x);
  }

  static public Point3D normalize (Point3D u) {
    double r = norm(u);
    return new Point3D (u.x/r, u.y/r, u.z/r);
  }

  static public Point3D normalTo (Point3D vector) {
    if      (vector.x==0.0) return new Point3D (1.0, 0.0, 0.0);
    else if (vector.y==0.0) return new Point3D (0.0, 1.0, 0.0);
    else if (vector.z==0.0) return new Point3D (0.0, 0.0, 1.0);
    else {
      double norm = Math.sqrt(vector.x*vector.x + vector.y*vector.y);
      return new Point3D (-vector.y/norm, vector.x/norm, 0.0);
    }
  }

} // end of clas
