/*
 * The org.opensourcephysics.display3d.simple3d package implements the
 * classes of the org.opensourcephysics.display3d package using
 * the so called painter's algorithm, in which the diferent parts of the
 * 3D scene are painted from back to front, thus achieving a simple, but
 * for many cases effective, hidden-line removal.
 *
 * Copyright (c) 2005  The Open Source Physics project
 *                     http://www.opensourcephysics.org
 */

package org.opensourcephysics.display3d.simple3d.utils;

/**
 * A simple object that has three double coordinates.
 * The coordinates are package accesible.
 */
public class Point3D {
  /**
   * The x coordinate of the point
   */
  final double x;
  /**
   * The y coordinate of the point
   */
  final double y;
  /**
   * The z coordinate of the point
   */
  final double z;

  /**
   * Constructor that sets the x,y,z coordinates of the point
   */
  public Point3D (double _x, double _y, double _z) {
    x = _x;
    y = _y;
    z = _z;
  }

  /**
   * Gets the X coordinate
   * @return double
   */
  public double getX() { return this.x; }
  /**
   * Gets the Y coordinate
   * @return double
   */
  public double getY() { return this.y; }
  /**
   * Gets the Z coordinate
   * @return double
   */
  public double getZ() { return this.z; }

  /**
   * Converts the point into a double[3] array
   * @return double[]
   */
  public double[] toArray() { return new double[] { x,y,z}; }

}

