/*
 * The org.opensourcephysics.display3d.simple3d package implements the
 * classes of the org.opensourcephysics.display3d package using
 * the so called painter's algorithm, in which the diferent parts of the
 * 3D scene are painted from back to front, thus achieving a simple, but
 * for many cases effective, hidden-line removal.
 *
 * Copyright (c) 2005  The Open Source Physics project
 *                     http://www.opensourcephysics.org
 */

package org.opensourcephysics.display3d.simple3d;

import org.opensourcephysics.display3d.simple3d.Element;

/**
 * <p>Title: Object3D class </p>
 * <p>Description: An Object3D is a minimal 3D graphical piece
 * that an Element can draw. The whole business consists is asking
 * each Element about its list of Object3D pieces, sorting them, and
 * finally draw them from back to front</p>
 * @author Francisco Esquembre
 * @version March 2005
 */
class Object3D {

  private final Element element;
  private int index;
  private double distance=Double.NaN;

  /**
   * Gets the element that contains this Object3D
   * @return Element
   */
  final Element getElement() { return this.element; }

  /**
   * Gets the reference number of this Object3D in its parent list of objects
   * @return int
   */
  final int getIndex() { return this.index; }

  /**
   * Sets the reference number of this Object3D in its parent list of objects.
   * Only subclasses should use this.
   * @param _index
   */
  protected final void setIndex(int _index) { this.index = _index; }

  /**
   * Sets the distance to this Object3D
   * This distance provides a criterion to determine the order in
   * which to draw all Objects3D in a DrawingPanel3D.
   * If Double.isNaN(distance), the Object3D will be ignored
   * by the panel. This can be used by Drawables3D to hide a given
   * Object3D.
   * This number is also used to modify the color of an object, so that
   * objects far away look darker and objects closer look brighter.
   * @param aDistance double
   */
  final void setDistance(double aDistance) { this.distance = aDistance; }
  /**
   * Gets the distance to this Object3D
   * @return double
   * @see #setDistance()
   */
  final double getDistance() { return this.distance; }

  /**
   * Constructor for this Object3D
   * @param _element The Element this Object3D is part of
   * @param _index    An integer that identifies the object within the drawable
   */
  public Object3D (Element _element, int _index) {
    this.element = _element;
    this.index = _index;
    this.distance = Double.NaN;
  }

  /**
   * A comparator class to be used by DrawingPanel3D to sort Object3D s
   */
  static class Comparator3D implements java.util.Comparator {
    public int compare(Object o1, Object o2) {
//        try {
        if      ( ((Object3D)o1).distance > ((Object3D)o2).distance) return -1;
        else if ( ((Object3D)o1).distance < ((Object3D)o2).distance) return +1;
        else return 0;
//        } catch (Exception _e) { return 0; } // Sometimes a NullPointerException happens
    }
  }

}
