/*
 * The org.opensourcephysics.display3d.simple3d package implements the
 * classes of the org.opensourcephysics.display3d package using
 * the so called painter's algorithm, in which the diferent parts of the
 * 3D scene are painted from back to front, thus achieving a simple, but
 * for many cases effective, hidden-line removal.
 *
 * Copyright (c) 2005  The Open Source Physics project
 *                     http://www.opensourcephysics.org
 */

package org.opensourcephysics.display3d.simple3d;

import org.opensourcephysics.controls.*;

/**
 * <p>Title: ElementSphere</p>
 * <p>Description: An Ellipsoid with the same size in all dimensions.</p>
 * <p>Changing the size in any dimension also sets the other sizes.
 * Setting different sizes to X, Y, and Z will result in setting the radius to
 * the largest of the three dimensions.</p>
 * @author Francisco Esquembre
 * @version May 2005
 */
public class ElementSphere extends ElementEllipsoid implements org.opensourcephysics.display3d.core.ElementSphere {

  public ElementSphere () { super(); }

  public ElementSphere (double radius) {
    super();
    setRadius(radius);
  }

  public void setRadius(double radius) { super.setSizeXYZ(radius, radius, radius); }

  public double getRadius() { return this.getSizeX(); }

// -------------------------------------
// Overwrite parent methods
// -------------------------------------

  public void setSizeX(double sizeX) { super.setSizeXYZ(sizeX, sizeX, sizeX); }

  public void setSizeY(double sizeY) { super.setSizeXYZ(sizeY, sizeY, sizeY); }

  public void setSizeZ(double sizeZ) { super.setSizeXYZ(sizeZ, sizeZ, sizeZ); }

  public void setSizeXYZ(double sizeX, double sizeY, double sizeZ) {
    double max = Math.max(Math.max(sizeX, sizeY), sizeZ);
    super.setSizeXYZ(max,max,max);
  }

// -------------------------------------
//  Private or protected methods
// -------------------------------------

// ----------------------------------------------------
// XML loader
// ----------------------------------------------------

}

