/*
 * The org.opensourcephysics.display3d.simple3d package implements the
 * classes of the org.opensourcephysics.display3d package using
 * the so called painter's algorithm, in which the diferent parts of the
 * 3D scene are painted from back to front, thus achieving a simple, but
 * for many cases effective, hidden-line removal.
 *
 * Copyright (c) 2005  The Open Source Physics project
 *                     http://www.opensourcephysics.org
 */

package org.opensourcephysics.display3d.simple3d;

import java.awt.*;
import java.awt.geom.AffineTransform;
import org.opensourcephysics.controls.*;
import org.opensourcephysics.display.TextLine;

/**
 * <p>Title: ElementCircle</p>
 * <p>Description: A Circle using the painter's algorithm</p>
 * @author Francisco Esquembre
 * @version March 2005
 */
public class ElementCircle extends Element implements org.opensourcephysics.display3d.core.ElementCircle {
  // Configuration variables

  // Implementation variables
  private double[] coordinates = new double[3];
  private double[] fullCoordinates = new double[6]; // The input for all projections
  private double[] pixel  = new double[5]; // The ouput of all projections
  private Object3D[] objects = new Object3D[] { new Object3D(this,0) };

  {
    setSizeXYZ(0,0,0);
  }
// -------------------------------------
// New configuration methods
// -------------------------------------

// -------------------------------------
// Abstract part of Element or Parent methods overwritten
// -------------------------------------

  Object3D[] getObjects3D() {
    if (!isVisible()) return null;
    if (hasChanged() || needsToProject()) projectPoints ();
    return objects;
  }

  void draw (Graphics2D _g2, int _index) {
    // Allow the panel to adjust color according to depth
    Color theColor = getPanel().projectColor(getRealStyle().getLineColor(),objects[0].getDistance());
    Color theFillColor = getPanel().projectColor(getRealStyle().getFillColor(),objects[0].getDistance());
    drawIt (_g2,theColor,theFillColor);
  }

  void drawQuickly (Graphics2D _g2) {
    if (!isVisible()) return;
    if (hasChanged() || needsToProject()) projectPoints ();
    drawIt (_g2, getRealStyle().getLineColor(),null); // getRealStyle().getFillColor());
  }

  void styleChanged (int styleThatChanged) { } // Not affected

// -------------------------------------
// Private methods
// -------------------------------------

  private void projectPoints () {
    coordinates[0] = coordinates[1] = coordinates[2] = 0.0;
    fullCoordinates[3] = getSizeX(); fullCoordinates[4] = getSizeY(); fullCoordinates[5] = getSizeZ();
    toSpace (coordinates);
    fullCoordinates[0] = coordinates[0]; fullCoordinates[1] = coordinates[1]; fullCoordinates[2] = coordinates[2];
    getPanel().project(fullCoordinates,pixel);
    objects[0].setDistance(pixel[4]);
    setElementChanged(false);
    setNeedToProject(false);
  }

  private void drawIt (Graphics2D _g2, Color _color, Color _fill) {
    int diameter = (int) Math.max(pixel[2],pixel[3]), radius = diameter/2;
    int xc = (int)pixel[0]-radius, yc = (int)pixel[1]-radius;
    _g2.setStroke(getRealStyle().getLineStroke());
    if (_fill!=null) { // First fill the inside
      _g2.setPaint(_fill);
      _g2.fillOval(xc,yc,diameter+1,diameter+1); // Is this a bug in Awt?
    }
    _g2.setColor (_color);
    _g2.drawOval(xc,yc,diameter,diameter);
  }

// ----------------------------------------------------
// XML loader
// ----------------------------------------------------

  /**
   * Returns an XML.ObjectLoader to save and load object data.
   * @return the XML.ObjectLoader
   */
  public static XML.ObjectLoader getLoader() { return new ElementCircleLoader(); }

  static private class ElementCircleLoader extends ElementLoader {

    public Object createObject(XMLControl control) { return new ElementCircle(); }

  }

}
