/*
 * The org.opensourcephysics.display3d.core package provides the basic
 * interfaces and classes that conform a basic drawing framework for 3D scenes.
 *
 * Subpackages should implement these interfaces using any of the available
 * 3D rendering mechanisms.
 *
 * Copyright (c) 2005  The Open Source Physics project
 *                     http://www.opensourcephysics.org
 */

package org.opensourcephysics.display3d.core;

import java.awt.Color;

/**
 * <p>Title: Style</p>
 * <p>Description: A class that holds display suggestions for 3D Elements.
 * Actual Elements may use or not all of the suggestions provided.</p>
 * @author Francisco Esquembre
 * @version March 2005
 */
public interface Style {

  public void setLineColor (Color _color);
  public Color getLineColor ();

  public void setLineWidth (float _width);
  public float getLineWidth ();

  public void setFillColor (Color _color);
  public Color getFillColor ();

  public void setResolution (Resolution _res);
  public Resolution getResolution ();

}
