/*
 * The org.opensourcephysics.display3d.core package provides the basic
 * interfaces and classes that conform a basic drawing framework for 3D scenes.
 *
 * Subpackages should implement these interfaces using any of the available
 * 3D rendering mechanisms.
 *
 * Copyright (c) 2005  The Open Source Physics project
 *                     http://www.opensourcephysics.org
 */

package org.opensourcephysics.display3d.core;

/**
 * <p>Title: Group</p>
 * <p>Description: A Group is an element that is made of other elements</p>
 * @author Francisco Esquembre
 * @version March 2005
 * @see Element
 */
public interface Group extends Element {

  /**
   * Adds an Element to this Group.
   * @param element Element
   * @see Element
   */
  public void addElement(Element element);

  /**
   * Removes an Element from this Group
   * @param element Element
   * @see Element
   */
  public void removeElement(Element element);

  /**
   * Removes all Elements from this Group
   * @see Element
   */
  public void removeAllElements();

  /**
   * Gets the cloned list of Elements in the group.
   * (Should be synchronized.)
   * @return cloned list
   */
  public java.util.ArrayList getElements();

}
