/*
 * The org.opensourcephysics.display3d.core package provides the basic
 * interfaces and classes that conform a basic drawing framework for 3D scenes.
 *
 * Subpackages should implement these interfaces using any of the available
 * 3D rendering mechanisms.
 *
 * Copyright (c) 2005  The Open Source Physics project
 *                     http://www.opensourcephysics.org
 */

package org.opensourcephysics.display3d.core;

/**
 * <p>Title: ElementSegment</p>
 * <p>Description: A 3D Segment.</p>
 * @author Francisco Esquembre
 * @version March 2005
 */
public interface ElementText extends Element {
    /**
     * Center the Text over the point
     */
    public final static int JUSTIFICATION_CENTER = 0;

    /**
     * Position the Text to the Left of the  point
     */
    public final static int JUSTIFICATION_LEFT = 1;

    /**
     * Position the Text to the Right of the  point
     */
    public final static int JUSTIFICATION_RIGHT = 2;

    /**
     * Sets the text to be displayed
     * @param text the String
     */
    public void setText (String text);
    /**
     * Gets the text displayed
     */
    public String getText ();

    /**
     * Sets the font for the text
     * @param font Font
     */
    public void setFont (java.awt.Font font);
    /**
     * Gets the font of the text
     * @return Font
     */
    public java.awt.Font getFont ();

    /**
     * Sets the justification for the text
     * @param font Font
     */
    public void setJustification (int justification);
    /**
     * Gets the justification of the text
     * @return Font
     */
    public int getJustification ();

    /**
     * Sets the rotation angle for the text. Default is 0.
     * @param angle the rotation angle
     */
    public void setRotationAngle (double angle);

    /**
     * Gets the rotation angle for the text
     */
    public double getRotationAngle ();

}













