/*
 * The org.opensourcephysics.display3d.core package provides the basic
 * interfaces and classes that conform a basic drawing framework for 3D scenes.
 *
 * Subpackages should implement these interfaces using any of the available
 * 3D rendering mechanisms.
 *
 * Copyright (c) 2005  The Open Source Physics project
 *                     http://www.opensourcephysics.org
 */

package org.opensourcephysics.display3d.core;

/**
 * <p>Title: ElementSurface</p>
 * <p>Description: A 3D Surface of the form (x(u,v),y(u,v),z(u,v))</p>
 * @author Francisco Esquembre
 * @version March 2005
 */
public interface ElementSurface extends Element {

    /**
     * Sets the data of the surface.
     * @param data the double[nu][nv][3] array of coordinates for the surface.
     */
    public void setData (double[][][] data);

    /**
     * Gets the data of the surface.
     * @return the double[nu][nv][3] array of coordinates of the surface.
     */
    public double[][][] getData ();
}













