/*
 * The org.opensourcephysics.display3d.core package provides the basic
 * interfaces and classes that conform a basic drawing framework for 3D scenes.
 *
 * Subpackages should implement these interfaces using any of the available
 * 3D rendering mechanisms.
 *
 * Copyright (c) 2005  The Open Source Physics project
 *                     http://www.opensourcephysics.org
 */

package org.opensourcephysics.display3d.core;

/**
 * <p>Title: ElementSpring</p>
 * <p>Description: A 3D spring.</p>
 * @author Francisco Esquembre
 * @version March 2005
 */
public interface ElementSpring extends Element {

    /**
     * Sets the radius of the spring.
     * @param radius the radius of the spring (normal to its direction)
     */
    public void setRadius (double radius);

    /**
     * Gets the radius of the spring.
     */
    public double getRadius ();

}













