/*
 * The org.opensourcephysics.display3d.core package provides the basic
 * interfaces and classes that conform a basic drawing framework for 3D scenes.
 *
 * Subpackages should implement these interfaces using any of the available
 * 3D rendering mechanisms.
 *
 * Copyright (c) 2005  The Open Source Physics project
 *                     http://www.opensourcephysics.org
 */

package org.opensourcephysics.display3d.core;

/**
 * <p>Title: ElementSphere</p>
 * <p>Description: An Ellipsoid with the same size in all dimensions.</p>
 * <p>Changing the size in any dimension also sets the other sizes.
 * Setting different sizes to X, Y, and Z will result in setting the radius to
 * the largest of the three dimensions.</p>
 * @author Francisco Esquembre
 * @version May 2005
 */
public interface ElementSphere extends ElementEllipsoid {

    /**
     * Sets the radius.
     * @param radius the radius
     */
    public void setRadius(double radius);
    /**
     * Gets the radius
     * @return the radius
     */
    public double getRadius();

}













