/*
 * The org.opensourcephysics.display3d.core package provides the basic
 * interfaces and classes that conform a basic drawing framework for 3D scenes.
 *
 * Subpackages should implement these interfaces using any of the available
 * 3D rendering mechanisms.
 *
 * Copyright (c) 2005  The Open Source Physics project
 *                     http://www.opensourcephysics.org
 */

package org.opensourcephysics.display3d.core;

/**
 * <p>Title: ElementPolygon</p>
 * <p>Description: A 3D polygon.</p>
 * Polygons can be closed (a real polygon) or open (polylines).
 * @author Francisco Esquembre
 * @version March 2005
 */
public interface ElementPolygon extends Element {

    /**
     * Sets whether the polygon is closed
     * @param closed boolean
     */
    public void setClosed (boolean closed);
    /**
     * Gets whether the polygon is closed
     * @return boolean
     */
    public boolean isClosed ();

    /**
     * Sets the data for the points of the polygon.
     * Each entry in the data array corresponds to one vertex.
     * If the polygon is closed, the last point will be connected
     * to the first one and the interior will be filled
     * (unless the fill color of the style is set to null).
     * @param data double[][] the double[nPoints][3] array with the data
     */
    public void setData (double[][] data);
    /**
     * Gets ths data of the points fo the polygon
     * @return double[][] the double[nPoints][3] array with the data
     */
    public double[][] getData ();

}













