/*
 * The org.opensourcephysics.display3d.core package provides the basic
 * interfaces and classes that conform a basic drawing framework for 3D scenes.
 *
 * Subpackages should implement these interfaces using any of the available
 * 3D rendering mechanisms.
 *
 * Copyright (c) 2005  The Open Source Physics project
 *                     http://www.opensourcephysics.org
 */

package org.opensourcephysics.display3d.core;

/**
 * <p>Title: ElementSurface</p>
 * <p>Description: A 3D plane.</p>
 * The plane is specified by (its position, size, and) its direction vectors</p>
 * @author Francisco Esquembre
 * @version March 2005
 */
public interface ElementPlane extends Element {

    /**
     * Sets the first direction vector of th eplane
     * @param data the double[3] array for the first vector
     */
    public void setFirstDirection (double[] vector);

    /**
     * Gets the first direction vector of th eplane
     * @return the double[3] array for the first vector
     */
    public double[] getFirstDirection ();

    /**
     * Sets the second direction vector of th eplane
     * @param data the double[3] array for the first vector
     */
    public void setSecondDirection (double[] vector);

    /**
     * Gets the second direction vector of th eplane
     * @return the double[3] array for the first vector
     */
    public double[] getSecondDirection ();

}













