/*
 * The org.opensourcephysics.display3d.core package provides the basic
 * interfaces and classes that conform a basic drawing framework for 3D scenes.
 *
 * Subpackages should implement these interfaces using any of the available
 * 3D rendering mechanisms.
 *
 * Copyright (c) 2005  The Open Source Physics project
 *                     http://www.opensourcephysics.org
 */

package org.opensourcephysics.display3d.core;

/**
 * <p>Title: ElementEllipsoid</p>
 * <p>Description: A 3D Ellipsoid.</p>
 * @author Francisco Esquembre
 * @version March 2005
 */
public interface ElementEllipsoid extends Element {

    /**
     * Sets the minimum angle for the meridians.
     * Default is 0.
     * @param angle the minimum angle (in degrees)
     */
    public void   setMinimumAngleU(int angle);
    /**
     * Gets the minimum angle for the meridians
     * @return the minimum angle (in degrees)
     */
    public int    getMinimumAngleU();

    /**
     * Sets the maximum angle for the meridians.
     * Default is 360.
     * @param angle the maximum angle (in degrees)
     */
    public void   setMaximumAngleU(int angle);
    /**
     * Gets the maximum angle for the meridians
     * @return the maximum angle (in degrees)
     */
    public int    getMaximumAngleU();

    /**
     * Sets the minimum angle for the parallels
     * Default is -90.
     * @param angle the minimum angle (in degrees)
     */
    public void   setMinimumAngleV(int angle);
    /**
     * Gets the minimum angle for the parallels
     * @return the minimum angle (in degrees)
     */
    public int    getMinimumAngleV();

    /**
     * Sets the maximum angle for the parallels
     * Default is 90.
     * @param angle the maximum angle (in degrees)
     */
    public void   setMaximumAngleV(int angle);
    /**
     * Gets the maximum angle for the parallels
     * @return the maximum angle (in degrees)
     */
    public int    getMaximumAngleV();

    /**
     * Whether an incomplete ellipsoid should be closed at its bottom.
     * @param closed the desired value
     */
    public void setClosedBottom (boolean close);

    /**
     * Whether the ellipsoid is closed at its bottom.
     * @return the value
     */
    public boolean isClosedBottom ();

    /**
     * Whether an incomplete ellipsoid should be closed at its top.
     * @param closed the desired value
     */
    public void setClosedTop (boolean close);

    /**
     * Whether the ellipsoid is closed at its top.
     * @return the value
     */
    public boolean isClosedTop ();

    /**
     * Whether an incomplete ellipsoid should be closed at its left side.
     * @param closed the desired value
     */
    public void    setClosedLeft (boolean close);
    /**
     * Whether the ellipsoid is closed at its left side.
     * @return the value
     */
    public boolean isClosedLeft ();

    /**
     * Whether an incomplete ellipsoid should be closed at its right side.
     * @param closed the desired value
     */
    public void    setClosedRight (boolean close);
    /**
     * Whether the ellipsoid is closed at its right side.
     * @return the value
     */
    public boolean isClosedRight ();

}













