/*
 * The org.opensourcephysics.display3d.core package provides the basic
 * interfaces and classes that conform a basic drawing framework for 3D scenes.
 *
 * Subpackages should implement these interfaces using any of the available
 * 3D rendering mechanisms.
 *
 * Copyright (c) 2005  The Open Source Physics project
 *                     http://www.opensourcephysics.org
 */

package org.opensourcephysics.display3d.core;

/**
 * <p>Title: ElementCylinder</p>
 * <p>Description: A 3D Cylinder.</p>
 * @author Francisco Esquembre
 * @version March 2005
 */
public interface ElementCylinder extends Element {

    /**
     * Sets the minimum angle to build the top and bottom faces of the cylinder.
     * Default is 0.
     * @param angle the minimum angle (in degrees)
     */
    public void   setMinimumAngle(int angle);
    /**
     * Gets the minimum angle used to build the top and bottom faces of the cylinder.
     * @return the minimum angle (in degrees)
     */
    public int    getMinimumAngle();

    /**
     * Sets the maximum angle to build the top and bottom faces of the cylinder.
     * Default is 360.
     * @param angle the maximum angle (in degrees)
     */
    public void   setMaximumAngle(int angle);
    /**
     * Gets the maximum angle used to build the top and faces sides of the cylinder.
     * @return the maximum angle (in degrees)
     */
    public int    getMaximumAngle();

    /**
     * Whether the element should be closed at its bottom.
     * @param closed the desired value
     */
    public void setClosedBottom (boolean close);

    /**
     * Whether the element is closed at its bottom.
     * @return the value
     */
    public boolean isClosedBottom ();

    /**
     * Whether the element should be closed at its top.
     * @param closed the desired value
     */
    public void setClosedTop (boolean close);

    /**
     * Whether the element is closed at its top.
     * @return the value
     */
    public boolean isClosedTop ();

    /**
     * Whether an incomplete element should be closed at its left side.
     * @param closed the desired value
     */
    public void    setClosedLeft (boolean close);
    /**
     * Whether the element is closed at its left side.
     * @return the value
     */
    public boolean isClosedLeft ();

    /**
     * Whether an incomplete element should be closed at its right side.
     * @param closed the desired value
     */
    public void    setClosedRight (boolean close);
    /**
     * Whether the element is closed at its right side.
     * @return the value
     */
    public boolean isClosedRight ();

}













