/*
 * The org.opensourcephysics.display3d.core package provides the basic
 * interfaces and classes that conform a basic drawing framework for 3D scenes.
 *
 * Subpackages should implement these interfaces using any of the available
 * 3D rendering mechanisms.
 *
 * Copyright (c) 2005  The Open Source Physics project
 *                     http://www.opensourcephysics.org
 */

package org.opensourcephysics.display3d.core;

/**
 * <p>Title: DrawingFrame3D</p>
 * <p>Description: DrawingFrame3D is the recommended frame for a DrawingPanel3D</p>
 * @author Francisco Esquembre
 * @version March 2005
 */
public interface DrawingFrame3D {

// ---------------------------------
// Adding the panel
// ---------------------------------

  /**
   *  Adds the drawing panel to the frame. The panel is added to the center
   *  of the frame's content pane.
   *
   * @param  drawingPanel
   */
  public void setDrawingPanel3D(DrawingPanel3D drawingPanel);

  /**
   * Gets the DrawingPanel3D
   * @return DrawingPanel3D
   */
  public DrawingPanel3D getDrawingPanel3D();

// ---------------------------------
// Accessing the JFrame inside it
// ---------------------------------

  /**
   * Getting the pointer to the real JFrame in it
   * @return JFrame
   */
  public javax.swing.JFrame getJFrame();

  /**
   * Showing and hiding the frame.
   * Usually equals to getJFrame().setVisible(visibility);
   * @param visibility boolean
   */
  public void setVisible(boolean visibility);

}
