/*
 * The org.opensourcephysics.display package contains components for rendering
 * two-dimensional scalar and vector fields.
 * Copyright (c) 2005  H. Gould, J. Tobochnik, and W. Christian.
 */
package org.opensourcephysics.display2d;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

import org.opensourcephysics.display.DrawingPanel;

public class SurfacePlotMouseController implements MouseListener, MouseMotionListener {
  Object surfacePlot;
  DrawingPanel drawingPanel;
  public SurfacePlotMouseController( DrawingPanel drawingPanel, Object surfacePlot) {
     this.surfacePlot=surfacePlot;
     this.drawingPanel=drawingPanel;
  }

  public void mouseEntered(MouseEvent e) {;}
  public void mouseExited(MouseEvent e) {;}

  public void mouseReleased(MouseEvent e) {
    if (surfacePlot instanceof SurfacePlot)
      ( (SurfacePlot) surfacePlot).mouseReleased(e, drawingPanel);
    else if (surfacePlot instanceof ComplexSurfacePlot)
      ( (ComplexSurfacePlot) surfacePlot).mouseReleased(e, drawingPanel);
  }

  public void mouseClicked(MouseEvent e) {
    ;
  }

  public void mousePressed(MouseEvent e){
    if (surfacePlot instanceof SurfacePlot)
      ( (SurfacePlot) surfacePlot).mousePressed(e, drawingPanel);
    else if (surfacePlot instanceof ComplexSurfacePlot)
      ( (ComplexSurfacePlot) surfacePlot).mousePressed(e, drawingPanel);
  }

  public void mouseMoved(MouseEvent e) {;}

  public void mouseDragged(MouseEvent e) {
    if (surfacePlot instanceof SurfacePlot)
      ( (SurfacePlot) surfacePlot).mouseDragged(e, drawingPanel);
    else if (surfacePlot instanceof ComplexSurfacePlot)
      ( (ComplexSurfacePlot) surfacePlot).mouseDragged(e, drawingPanel);
  }
}
