package org.opensourcephysics.display2d;

import javax.swing.table.AbstractTableModel;

import org.opensourcephysics.controls.ControlUtils;

public class GridTableModel extends AbstractTableModel{

  GridData griddata;
  int component;

  public GridTableModel(GridData griddata, int component) {
    this.griddata=griddata;
    this.component=component;
  }

  /**
   * Gets the number of columns.
   *
   * @return int
   */
  public int getColumnCount() {
    return griddata.getNx()+1;
  }

  /**
   * Gets the number of columns.
   *
   * @return int
   */
  public String getColumnName(int c) {
    if(c==0) return "j\\i";
    return ""+(c-1);
  }


  /**
   * Gets the number of rows.
   *
   * @return int
   */
  public int getRowCount() {
    return griddata.getNx();
  }

  /**
   * Gets the value at the given grid location.
   *
   * @param rowIndex int
   * @param columnIndex int
   * @return Object
   */
  public Object getValueAt(int rowIndex, int columnIndex) {
    //return new Double(griddata.getValue(rowIndex,columnIndex,0));
    if(columnIndex==0) return new Integer(rowIndex);
    return ControlUtils.f3(griddata.getValue(columnIndex-1,rowIndex,component));
  }

}
