package org.opensourcephysics.display2d;


public class Carpet extends InterpolatedPlot {

   public Carpet(GridData griddata) {
     super(griddata);
     setShowGridLines(false);
   }

  public void setTopRow(double[][] line){
    if (image == null)return;
    if (rgbData[0].length != image.getWidth() * image.getHeight())return;
    if (griddata instanceof ArrayData) { // replace top row of array
      for (int c = 0; c < line.length; c++) {
        double[][] data = griddata.getData()[c];
        int len = data[0].length - 1;
        for (int ix = 0, nx = data.length; ix < nx; ix++) {
          System.arraycopy(data[ix], 0, data[ix], 1, len);
          data[ix][0] = line[c][ix];
        }
      }
    } else {
      double[][][] data = griddata.getData();
      for (int ix = 0, nx = data.length; ix < nx; ix++) {
        int len = line.length;
        for (int ny = data[0].length-1, iy=ny; iy >0; iy--) {
          System.arraycopy(data[ix][iy - 1], 2, data[ix][iy], 2, len);
        }
        for (int c = 0; c < len; c++) {
          data[ix][0][2 + c] = line[c][ix];
        }
      }
    }
    double dy = (griddata.getBottom() - griddata.getTop()) / (image.getHeight() - 1);
    int nr=1+(int)Math.abs(griddata.getDy()/dy);
    int offset=nr*image.getWidth();
    int length=rgbData[0].length-offset;
     System.arraycopy(rgbData[0],0,rgbData[0],offset,length);
     System.arraycopy(rgbData[1],0,rgbData[1],offset,length);
    System.arraycopy(rgbData[2],0,rgbData[2],offset,length);
    byte[] rgb = new byte[3];
    double y = griddata.getTop();
    double dx = (griddata.getRight() - griddata.getLeft()) / (image.getWidth() - 1);
    for (int i = 0; i < nr; i++) {
      double x=griddata.getLeft();
      for(int j=0,col=image.getWidth(); j<col; j++){
        colorMap.doubleToComponents(griddata.interpolate(x,y,ampIndex),rgb);
        int index=i*col+j;
        rgbData[0][index]=rgb[0]; // red
        rgbData[1][index]=rgb[1]; // green
        rgbData[2][index]=rgb[2]; // blue
        x+=dx;
      }
      y+=dy;
    }
  }

}
