package org.opensourcephysics.display.dialogs;

import java.awt.Dimension;

import javax.swing.JDialog;

import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLTreePanel;
import org.opensourcephysics.display.DrawingPanel;

/**
 * XMLDrawingPanelInspector displays properties of the drawing panel using the OSP XML framework.
 * @author Doug Brown
 * @author Wolfgang Christian
 * @version 1.0
 */
public class XMLDrawingPanelInspector extends JDialog {
  static XMLDrawingPanelInspector inspector;

  public XMLDrawingPanelInspector() {
    setSize(new Dimension(600, 300));
  }

  public static XMLDrawingPanelInspector getInspector(DrawingPanel dp){
    if (inspector == null) inspector = new XMLDrawingPanelInspector();
    XMLControl control = new XMLControlElement(dp);
    XMLTreePanel treePanel = new XMLTreePanel(control);
    inspector.setContentPane(treePanel);
    inspector.setVisible(true);
    return inspector;
  }

}
