package org.opensourcephysics.display.dialogs;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import org.opensourcephysics.display.PlottingPanel;


/**
 * Displays and sets DrawingPanel log-scale properties.
 *
 * @author Wolfgang Christian
 * @version 1.0
 */
public class LogAxesInspector extends JDialog {
  // instance fields
  protected PlottingPanel plotPanel;
  protected JPanel dataPanel;
  protected JCheckBox logXCheckBox;
  protected JCheckBox logYCheckBox;
  protected JButton okButton;

  /**
   * Constructs an LogAxis Inspector.
   *
   * @param panel the track plotting panel
   */
  public LogAxesInspector(PlottingPanel panel) {
    super((Frame)null, true); // modal dialog with no owner
    plotPanel = panel;
    setTitle(DialogsRes.LOG_SCALE);
    setResizable(false);
    createGUI();
    pack();
  }

//_____________________________ private methods ____________________________

/**
 * Creates the visible components for the clip.
 */
  private void createGUI() {
    logXCheckBox = new JCheckBox(DialogsRes.LOG_X);
    logXCheckBox.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        plotPanel.setLogScaleX(logXCheckBox.isSelected());
        plotPanel.scale();
        updateDisplay();
        plotPanel.repaint();
      }
    });
    logYCheckBox = new JCheckBox(DialogsRes.LOG_Y);
    logYCheckBox.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        plotPanel.setLogScaleY(logYCheckBox.isSelected());
        plotPanel.scale();
        updateDisplay();
        plotPanel.repaint();
      }
    });
    JPanel inspectorPanel = new JPanel(new BorderLayout());
    setContentPane(inspectorPanel);
    JPanel controlPanel = new JPanel(new BorderLayout());
    inspectorPanel.add(controlPanel, BorderLayout.SOUTH);
    // create panels and add labels, fields and check boxes
    JPanel xPanel = new JPanel(new GridLayout(1, 2));
    xPanel.setBorder(BorderFactory.createTitledBorder(DialogsRes.LOG_WARNING));
    dataPanel = new JPanel(new GridLayout(1, 1));
    dataPanel.setBorder(BorderFactory.createEtchedBorder());
    controlPanel.add(dataPanel, BorderLayout.CENTER);
    Box box;
    box = Box.createHorizontalBox();
    box.add(Box.createHorizontalGlue());
    xPanel.add(logXCheckBox);
    xPanel.add(box);
    box = Box.createHorizontalBox();
    box.add(Box.createHorizontalGlue());
    xPanel.add(box);
    box = Box.createHorizontalBox();
    box.add(Box.createHorizontalGlue());
    xPanel.add(logYCheckBox);
    dataPanel.add(xPanel);
    logXCheckBox.setAlignmentX(Component.RIGHT_ALIGNMENT);
    logYCheckBox.setAlignmentX(Component.RIGHT_ALIGNMENT);
    // create ok button
    okButton = new JButton(DialogsRes.LOG_OK);
    okButton.setForeground(new Color(0, 0, 102));
    okButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        setVisible(false);
      }
    });
    JPanel buttonbar = new JPanel();
    controlPanel.add(buttonbar, BorderLayout.SOUTH);
    buttonbar.add(okButton);
  }

  /**
   * Updates this inpector to reflect the current settings.
   */
  public void updateDisplay() {
    logXCheckBox.setSelected(plotPanel.isLogScaleX());
    logYCheckBox.setSelected(plotPanel.isLogScaleY());
  }

  /**
   * Reverts to the previous clip settings.
   */
  private void revert() {
  }
}

