package org.opensourcephysics.display.dialogs;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
/**
 * String constants for OSPControls.
 *
 * @author Wolfgang Christian
 * @version 1.0
 */

public class DialogsRes {
  public static final String AUTOSCALE_AUTOSCALE;
  public static final String AUTOSCALE_AUTO;
  public static final String AUTOSCALE_OK;
  public static final String AUTOSCALE_ZOOM_WARNING;

  public static final String SCALE_SCALE;
  public static final String SCALE_MIN;
  public static final String SCALE_MAX;
  public static final String SCALE_AUTO;
  public static final String SCALE_CANCEL;
  public static final String SCALE_OK;

  public static final String LOG_SCALE;
  public static final String LOG_X;
  public static final String LOG_Y;
  public static final String LOG_OK;
  public static final String LOG_WARNING;

  private DialogsRes() {
  }

  private static String getString( final ResourceBundle bundle, final String key){
    try{
      return bundle.getString(key);
    }catch (final MissingResourceException ex){
        //assert(false) : ex.getMessage();
        return '|'+key+'|';
    }
  }

  static{
    final String BUNDLE_NAME="org.opensourcephysics.resources.display.dialogs_res";
    final ResourceBundle BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME,Locale.getDefault(),DialogsRes.class.getClassLoader());
    AUTOSCALE_AUTOSCALE=getString(BUNDLE, "AUTOSCALE_AUTOSCALE");
    AUTOSCALE_AUTO=getString(BUNDLE, "AUTOSCALE_AUTO");
    AUTOSCALE_OK=getString(BUNDLE, "AUTOSCALE_OK");
    AUTOSCALE_ZOOM_WARNING=getString(BUNDLE, "AUTOSCALE_ZOOM_WARNING");

    SCALE_SCALE=getString(BUNDLE, "SCALE_SCALE");
    SCALE_MIN=getString(BUNDLE, "SCALE_MIN");
    SCALE_MAX=getString(BUNDLE, "SCALE_MAX");
    SCALE_AUTO=getString(BUNDLE, "SCALE_AUTO");
    SCALE_CANCEL=getString(BUNDLE, "SCALE_CANCEL");
    SCALE_OK=getString(BUNDLE, "SCALE_OK");

    LOG_SCALE=getString(BUNDLE, "LOG_SCALE");
    LOG_X=getString(BUNDLE, "LOG_X");
    LOG_Y=getString(BUNDLE, "LOG_Y");
    LOG_OK=getString(BUNDLE, "LOG_OK");
    LOG_WARNING=getString(BUNDLE, "LOG_WARNING");
  }

}
