package org.opensourcephysics.display.dialogs;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;

import org.opensourcephysics.display.DrawingPanel;


/**
 * This displays and the DrawingPanel autoscale properties.
 *
 * @author W. Christian
 * @version 1.0
 */
public class AutoScaleInspector extends JDialog {
  // instance fields
  protected DrawingPanel plotPanel;
  protected JPanel dataPanel;
  protected JCheckBox xAutoscaleCheckBox;
  protected JCheckBox yAutoscaleCheckBox;
  protected JButton okButton;

  /**
   * Constructs an Autoscale Inspector.
   *
   * @param panel the track plotting panel
   */
  public AutoScaleInspector(DrawingPanel panel) {
    super((Frame)null, true); // modal dialog with no owner
    plotPanel = panel;
    setTitle(DialogsRes.AUTOSCALE_AUTOSCALE);
    setResizable(false);
    createGUI();
    pack();
  }

//_____________________________ private methods ____________________________

/**
 * Creates the visible components for the clip.
 */
  private void createGUI() {
    xAutoscaleCheckBox = new JCheckBox(DialogsRes.AUTOSCALE_AUTO+" x");
    xAutoscaleCheckBox.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        plotPanel.setAutoscaleX(xAutoscaleCheckBox.isSelected());
        plotPanel.scale();
        updateDisplay();
        plotPanel.repaint();
      }
    });
    yAutoscaleCheckBox = new JCheckBox(DialogsRes.AUTOSCALE_AUTO+" y");
    yAutoscaleCheckBox.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        plotPanel.setAutoscaleY(yAutoscaleCheckBox.isSelected());
        plotPanel.scale();
        updateDisplay();
        plotPanel.repaint();
      }
    });
    JPanel inspectorPanel = new JPanel(new BorderLayout());
    setContentPane(inspectorPanel);
    JPanel controlPanel = new JPanel(new BorderLayout());
    inspectorPanel.add(controlPanel, BorderLayout.SOUTH);
    // create panels and add labels, fields and check boxes
    JPanel xPanel = new JPanel(new GridLayout(1, 2));
    xPanel.setBorder(BorderFactory.createTitledBorder(DialogsRes.AUTOSCALE_ZOOM_WARNING));
    dataPanel = new JPanel(new GridLayout(1, 1));
    dataPanel.setBorder(BorderFactory.createEtchedBorder());
    controlPanel.add(dataPanel, BorderLayout.CENTER);
    Box box;
    box = Box.createHorizontalBox();
    box.add(Box.createHorizontalGlue());
    xPanel.add(xAutoscaleCheckBox);
    xPanel.add(box);
    box = Box.createHorizontalBox();
    box.add(Box.createHorizontalGlue());
    xPanel.add(box);
    box = Box.createHorizontalBox();
    box.add(Box.createHorizontalGlue());
    xPanel.add(yAutoscaleCheckBox);
    dataPanel.add(xPanel);
    xAutoscaleCheckBox.setAlignmentX(Component.RIGHT_ALIGNMENT);
    yAutoscaleCheckBox.setAlignmentX(Component.RIGHT_ALIGNMENT);
    // create ok button
    okButton = new JButton(DialogsRes.AUTOSCALE_OK);
    okButton.setForeground(new Color(0, 0, 102));
    okButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        setVisible(false);
      }
    });
    // create buttonbar and add buttons
    //JPanel buttonbar = new JPanel(new GridLayout(1, 2));
    JPanel buttonbar = new JPanel();
    controlPanel.add(buttonbar, BorderLayout.SOUTH);
    buttonbar.add(okButton);
    //buttonbar.add(cancelButton);
  }

  /**
   * Updates this inpector to reflect the current settings.
   */
  public void updateDisplay() {
    xAutoscaleCheckBox.setSelected(plotPanel.isAutoscaleX());
    yAutoscaleCheckBox.setSelected(plotPanel.isAutoscaleY());
  }

  /**
   * Reverts to the previous clip settings.
   */
  private void revert() {
  }
}
