package org.opensourcephysics.display.axes;

import java.awt.event.MouseEvent;
import java.text.DecimalFormat;

import org.opensourcephysics.display.DrawingPanel;

/**
 * Builds a coordinate string from a mouse event for an axis type.
 */

public class PolarCoordinateStringBuilder extends CoordinateStringBuilder{

  protected DecimalFormat    scientificFormat = new DecimalFormat("0.###E0");  // coordinate display format for message box.
  protected DecimalFormat    decimalFormat    = new DecimalFormat("0.00");     // coordinate display format for message box.
  protected String xLabel="r=";
  protected String yLabel="  phi=";

  public PolarCoordinateStringBuilder() {
    this("r=","  phi=");
  }

  public PolarCoordinateStringBuilder(String xLabel, String yLabel) {
    this.xLabel=xLabel;
    this.yLabel=yLabel;
  }

  public void setCoordinateLabels(String xLabel, String yLabel){
    this.xLabel=xLabel;
    this.yLabel=yLabel;
  }

  /**
   * Converts a the pixel coordinates in a mouse event into world coordinates and
   * return these coordinates in a string.
   *
   * @param e the mouse event
   * @return the coordinate string
   */
  public String getCoordinateString(DrawingPanel panel, MouseEvent e) {
    double x = panel.pixToX(e.getPoint().x);
    double y = panel.pixToY(e.getPoint().y);
    double r = Math.sqrt(x * x + y * y);
    String msg;
    if ( (r > 100) || (r < 0.01)) {
      msg = "r=" + scientificFormat.format( (float) r);
    }
    else {
      msg = "r=" + decimalFormat.format( (float) r);
    }
    msg += "  phi=" + decimalFormat.format(180 * (float) Math.atan2(y, x) / Math.PI);
    return msg;

  }


}