package org.opensourcephysics.display.axes;

import java.awt.Color;
import java.awt.Graphics;

import org.opensourcephysics.display.DrawingPanel;

/**
 * PolarAxes defines common polar coordinate methods.
 *
 * @author W. Christian
 */

public interface PolarAxes extends DrawableAxes {

  /**
   * Sets the spacing of the radial gridlines.
   * @param dr
   */
  public void setDeltaR(double dr);

  /**
   * Gets the spacing of the radial gridlines.
   * @param dr
   */
  public double getDeltaR();

  /**
   * Sets the spacing of the radial gridlines.
   * @param dtheta in degree
   */
  public void setDeltaTheta(double dtheta);

  /**
   * Gets the spacing of the radial gridlines.
   * @param dr
   */
  public double getDeltaTheta();

  /**
 * Draws the rings for the polar plot.
 * @param panel
 * @param g
 */
 public void drawRings(double rmax, DrawingPanel panel, Graphics g);

 /**
 * Draws the spokes for the polar plot.
 * @param panel
 * @param g
 */
public void drawSpokes(double rmax, DrawingPanel panel, Graphics g);

/**
 * Sets the interior background color.
 */
public void setInteriorBackground(Color color);

}
