/*
 *  The org.opensourcephysics.display package contains the drawing framework
 *  for the book Simulations in Physics.  This framework defines objects that
 *  implement the Drawable interface and a DrawingPanel for rendering these objects.
 *  Copyright (c) 2005  H. Gould, J. Tobochnik, and W. Christian.
 */
package  org.opensourcephysics.display.axes;
import java.awt.Color;

import org.opensourcephysics.display.Drawable;

/**
 * DrawableAxes defines axes that render themselves in a drawing panel.
 *
 * Axes use the plotting panel's gutters, pixel scale, and affine
 * transformation.
 *
 * @author W. Christian
 */
public interface DrawableAxes extends Drawable {

  /**
   * Sets the x label of the axes.
   * The font names understood are those understood by java.awt.Font.decode().
   * If the font name is null, the font remains unchanged.
   *
   * @param  s the label
   * @param font_name an optional font name
   */
  void setXLabel(String s, String font_name);

  /**
   * Gets the x axis label.
   *
   * @return String
   */
  String getXLabel();

  /**
   * Sets the y label of the axes.
   * The font names understood are those understood by java.awt.Font.decode().
   * If the font name is null, the font remains unchanged.
   *
   * @param  s the label
   * @param font_name an optional font name
   */
  void setYLabel(String s, String font_name);

  /**
   * Gets the y axis label.
   *
   * @return String
   */
  String getYLabel();


  /**
   * Sets the title that will be drawn within the drawing panel.
   * The font names understood are those understood by java.awt.Font.decode().
   * If the font name is null, the font remains unchanged.
   *
   * @param s the title
   * @param font_name an optional font name
   */
  void setTitle(String s, String font_name);

  /**
   * Gets the x title.
   *
   * @return String
   */
  String getTitle();


  /**
   * Sets the visibility of the axes.
   *
   * @param isVisible true if the axes are visible
   */
  void setVisible(boolean isVisible);

  /**
   * Sets the interior background color.
   */
  void setInteriorBackground(Color color);

  /**
   * Shows a grid line for every x axis major tickmark.
   */
  void setShowMajorXGrid(boolean showGrid);

  /**
   * Shows a grid line for every x axis minor tickmark.
   */
  void setShowMinorXGrid(boolean showGrid);

  /**
   * Shows a grid line for every y axis major tickmark.
   */
  void setShowMajorYGrid(boolean showGrid);

  /**
   * Shows a grid line for every y axis minor tickmark.
   */
  void setShowMinorYGrid(boolean showGrid);

}
