package org.opensourcephysics.display.axes;

import java.awt.event.MouseEvent;
import java.text.DecimalFormat;

import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.GUIUtils;

/**
 * Builds a coordinate string from a mouse event for an axis type.
 */

public abstract class CoordinateStringBuilder {

  protected DecimalFormat    scientificFormat = new DecimalFormat("0.###E0");  // coordinate display format for message box.
  protected DecimalFormat    decimalFormat    = new DecimalFormat("0.00");     // coordinate display format for message box.
  protected String xLabel="x=";
  protected String yLabel="  y=";

  public void setCoordinateLabels(String xLabel, String yLabel){
    this.xLabel= GUIUtils.parseTeX(xLabel);
    this.yLabel=GUIUtils.parseTeX(yLabel);
  }

  /**
   * Converts a the pixel coordinates in a mouse event into world coordinates and
   * return these coordinates in a string.
   *
   * @param e the mouse event
   * @return the coordinate string
   */
  public abstract String getCoordinateString(DrawingPanel panel, MouseEvent e);

  /**
   * Creates the default builder for cartesian coordiantes.
   * @return
   */
  public static CoordinateStringBuilder createCartesian() {
    return new CartesianCoordinateStringBuilder();
  }

  /**
   * Creates the default builder for polar coordinates.
   * @return
   */
  public static CoordinateStringBuilder createPolar() {
    return new PolarCoordinateStringBuilder();
  }

}
