package org.opensourcephysics.display.axes;

import java.awt.event.MouseEvent;
import java.text.DecimalFormat;

import org.opensourcephysics.display.DrawingPanel;

/**
 * Builds a coordinate string from a mouse event for an axis type.
 */

public class CartesianCoordinateStringBuilder extends CoordinateStringBuilder {

  protected DecimalFormat    scientificFormat = new DecimalFormat("0.###E0");  // coordinate display format for message box.
  protected DecimalFormat    decimalFormat    = new DecimalFormat("0.00");     // coordinate display format for message box.
  protected String xLabel="x=";
  protected String yLabel="  y=";

  public CartesianCoordinateStringBuilder() {
    this("x=","  y=");
  }

  public CartesianCoordinateStringBuilder(String xLabel, String yLabel) {
    this.xLabel=xLabel;
    this.yLabel=yLabel;
  }

  public void setCoordinateLabels(String xLabel, String yLabel){
    this.xLabel=xLabel;
    this.yLabel=yLabel;
  }

/**
 * Converts a the pixel coordinates in a mouse event into world coordinates and
 * return these coordinates in a string.
 *
 * @param e the mouse event
 * @return the coordinate string
 */
public String getCoordinateString(DrawingPanel panel, MouseEvent e) {
  double x = panel.pixToX(e.getPoint().x);
  double y = panel.pixToY(e.getPoint().y);
  String msg;
  if ( (Math.abs(x) > 100) || (Math.abs(x) < 0.01) || (Math.abs(y) > 100) ||
      (Math.abs(y) < 0.01)) {
    msg = xLabel + scientificFormat.format( (float) x) + yLabel +
        scientificFormat.format( (float) y);
  }
  else {
    msg = xLabel + decimalFormat.format( (float) x) + yLabel +
        decimalFormat.format( (float) y);
  }
  return msg;
}


}