package org.opensourcephysics.display.axes;


/**
 * CartesianAxes defines common Cartesian coordinate methods.
 *
 * @author W. Christian
 */

public interface CartesianAxes extends DrawableAxes {

  /**
   * Sets the drawing location.
   * @param x
   */
  public void setX(double x);

  /**
   * Sets the drawing location.
   * @param x
   */
  public void setY(double y);

  /**
   * Gets the drawing location.
   * @param the x location
   */
  public double getX();

  /**
   * Gets the drawing location.
   * @param the y location
   */
  public double getY();

  /**
   *  Determines if the x axis is logarithmic.
   *
   * @return  true if logarithmic; false otherwise
   */
  public boolean isXLog();

  /**
   *  Deteermines if the y axis is logarithmic.
   *
   * @return  true if logarithmic; false otherwise
   */
  public boolean isYLog();

  /**
   * Sets the x axis to linear or logarithmic.
   *
   * @param isLog true for log scale; false otherwise
   */
  void setXLog(boolean isLog);

  /**
   * Sets the y axis to linear or logarithmic.
   *
   * @param isLog true for log scale; false otherwise
   */
  void setYLog(boolean isLog);


}