package  org.opensourcephysics.display.axes;

import org.opensourcephysics.display.PlottingPanel;


public abstract class AxisFactory {
	final static String axisProperty = "org.opensourcephysics.display.axes.AxisFactory"; // system property that determines which axis to use
	final static String defaultAxisFactoryInstance = "org.opensourcephysics.display.axes.CartesianType1Factory"; // default Axis implementation

	public static AxisFactory newInstance() {
                String axisClass = defaultAxisFactoryInstance;
		try {
			axisClass = System.getProperty(axisProperty);
			if(axisClass==null) {
				axisClass= defaultAxisFactoryInstance;
			}
		} catch(SecurityException se) {
		}
		try {
			Class c = Class.forName(axisClass);
			return (AxisFactory) c.newInstance();
		} catch(ClassNotFoundException cnfe) {
		} catch(InstantiationException ie) {
		} catch(IllegalAccessException iae) {}
		return null;

	}

        public static AxisFactory newInstance(String axisClass) {
          if(axisClass==null) {
            axisClass= defaultAxisFactoryInstance;
          }
          try {
            Class c = Class.forName(axisClass);
            return (AxisFactory) c.newInstance();
          } catch(ClassNotFoundException cnfe) {
          } catch(InstantiationException ie) {
            } catch(IllegalAccessException iae) {}
            return null;
        }

        public abstract DrawableAxes createAxes(PlottingPanel panel);

        public static DrawableAxes createAxesType1(PlottingPanel panel) {
          return new CartesianType1(panel);
        }

        public static DrawableAxes createAxesType2(PlottingPanel panel) {
          return new CartesianType2(panel);
        }

        public static DrawableAxes createAxesType3(PlottingPanel panel) {
          return new CartesianType3(panel);
        }

}

class CartesianType1Factory extends AxisFactory {

  public DrawableAxes createAxes(PlottingPanel panel) {
    return new CartesianType1(panel);
  }
}


