package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;

public class TextBox implements Drawable {
  public static final int COORDINATE_PLACEMENT=0;
  public static final int PIXEL_PLACEMENT=1;
  public static final int RELATIVE_PLACEMENT=2;
  public static final int BOTTOM_LEFT_PLACEMENT=3;
  public static final int TOP_LEFT_PLACEMENT=4;
  public static final int BOTTOM_RIGHT_PLACEMENT=5;
  public static final int TOP_RIGHT_PLACEMENT=6;
  public static final int BOTTOM_LEFT_GUTTER_PLACEMENT=7;
  public static final int TOP_LEFT_GUTTER_PLACEMENT=8;
  public static final int BOTTOM_RIGHT_GUTTER_PLACEMENT=9;
  public static final int TOP_RIGHT_GUTTER_PLACEMENT=10;
  public int placement_mode=COORDINATE_PLACEMENT;

  protected String text=null;
  protected Font font;
  protected String fontname  = "TimesRoman"; //The logical name of the font to use
  protected int    fontsize  = 14; //The font size
  protected int    fontstyle = Font.PLAIN; //The font style
  protected Color  color=Color.black;
  protected double x, y;
  protected int xoffset=0, yoffset=0;
  protected int xpix=0, ypix=0;
  protected int boxHeight=0, boxWidth=0;  // the box width and height

  public TextBox() {
     font = new Font(fontname, fontstyle, fontsize);
  }

  public TextBox(String str) {
     this();
     text=str;
  }

  public void setXY(double _x, double _y){
    x=_x;
    y=_y;
  }

  public void setText(String _text){
    text=_text;
  }

  public void setText(String _text, double _x, double _y){
    x=_x;
    y=_y;
    text=_text;
  }

  public void resetBoxSize(){
    boxHeight=0;
    boxWidth=0;
  }

  public void draw (DrawingPanel panel, Graphics g) {
      String tempText=text;  // local reference for thread safety
      if(tempText==null) return;
      Graphics2D g2= (Graphics2D) g;
      g2.setColor(color);
      Font oldFont=g2.getFont();
      g2.setFont(font);
      FontMetrics fm=g.getFontMetrics();
      int sh=fm.getAscent()+4; // current string height
      int sw=fm.stringWidth(tempText)+6;  // current string width
      boxHeight=Math.max(boxHeight,sh);
      boxWidth=Math.max(boxWidth,sw);
      switch(placement_mode){
        case PIXEL_PLACEMENT:
          xpix = (int) x;
          ypix = (int) y;
          break;
        case RELATIVE_PLACEMENT:
          xpix = (int) (x*panel.getWidth());
          ypix = (int) ((1-y)*panel.getHeight());
          break;
        case TOP_LEFT_PLACEMENT:
          xpix = 0;
          ypix = 0;
          break;
        case TOP_LEFT_GUTTER_PLACEMENT:
          xpix = panel.getLeftGutter();
          ypix = panel.getTopGutter();
          break;
        case BOTTOM_LEFT_PLACEMENT:
          xpix = 0;
          ypix = panel.getHeight()-boxHeight-yoffset-1;
          break;
        case BOTTOM_LEFT_GUTTER_PLACEMENT:
          xpix = panel.getLeftGutter();
          ypix = panel.getHeight() - boxHeight - yoffset - 1-panel.getBottomGutter();
          break;
        case TOP_RIGHT_PLACEMENT:
          xpix = panel.getWidth()-boxWidth-1;
          ypix = 0;
          break;
        case TOP_RIGHT_GUTTER_PLACEMENT:
          xpix = panel.getWidth()-boxWidth-1-panel.getRightGutter();
          ypix = panel.getTopGutter();
          break;
        case BOTTOM_RIGHT_PLACEMENT:
          xpix = panel.getWidth()-boxWidth-1;
          ypix = panel.getHeight()-boxHeight-yoffset-1;
          break;
        case BOTTOM_RIGHT_GUTTER_PLACEMENT:
          xpix = panel.getWidth() - boxWidth - 1-panel.getRightGutter();
          ypix = panel.getHeight() - boxHeight - yoffset - 1-panel.getBottomGutter();
          break;
        default:
          xpix = panel.xToPix (x);
          ypix = panel.yToPix (y);
          break;
      }
      boolean clip=panel.isClipAtGutter();
      Shape      clipShape = g2.getClip();
      g2.setClip(0,0,panel.getWidth(),panel.getHeight());
      g2.setColor(Color.yellow);
      g2.fillRect(xpix+xoffset,ypix+yoffset,boxWidth,boxHeight);
      g2.setColor(Color.black);
      g2.drawRect(xpix+xoffset,ypix+yoffset,boxWidth,boxHeight);
      g2.drawString(tempText,xpix+3+xoffset,ypix+boxHeight-2+yoffset);
      g2.setFont(oldFont);
      g2.setClip(clipShape);
  }
}