/*
 * The org.opensourcephysics.display package contains the drawing framework
 * for the book Simulations in Physics.  This framework defines objects that
 * implement the Drawable interface and a DrawingPanel for rendering these objects.
 * Copyright (c) 2002  H. Gould, J. Tobochnik, and W. Christian.
 */
package org.opensourcephysics.display;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.image.BufferStrategy;

import javax.swing.JApplet;
import javax.swing.JDialog;

/**
 * OSPDialog is a standard dialog that can remain hidden in applet mode.
 *
 * Copyright:    Copyright (c) 2002
 * @author       Wolfgang Christian
 * @version 1.0
 */
public class OSPDialog extends JDialog {
  static int topx = 10;
  static int topy = 100;

  /** Set <I>true</I> if the program is an applet. */
  public static boolean appletMode = false;

  /** Field myApplet provides a static reference to an applet context
   * so that the document base and code base can be obtained in applet mode.
   */
  public static JApplet applet;

  /** The thread group that created this object.*/
  public ThreadGroup constructorThreadGroup = Thread.currentThread().
      getThreadGroup();

  protected boolean keepHidden = false;
  protected BufferStrategy strategy;

  /**
   * Constricts a dialog that can be kept hidden in applets.
   *
   * @param owner Dialog
   * @param title String
   * @param modal boolean
   */
  public OSPDialog(Frame owner, String title, boolean modal) {
    super(owner, title, modal);
    if (appletMode) {
      keepHidden = true;
    }
    setLocation(topx, topy);
    Dimension d = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
    topx = Math.min(topx + 20, (int) d.getWidth() - 100);
    topy = Math.min(topy + 20, (int) d.getHeight() - 100);
  }

  /**
   * OSPDialog constructor with a title.
   */
  public OSPDialog(String title) {
    this(null, title, false);
  }

  /**
   * OSPDialog constructor.
   */
  public OSPDialog() {
    this("");
  }

  public void setSize(int width, int height) {
    super.setSize(width, height);
    validate();
  }

  /**
   * Shows the frame on the screen if the keep hidden flag is false.
   *
   * @deprecated
   */
  public void show() {
    if (!keepHidden) {
      super.show();
    }
  }

  /**
   * Sets the keepHidden flag.
   *
   * @param _keepHidden
   */
  public void setKeepHidden(boolean _keepHidden) {
    keepHidden = _keepHidden;
    //setVisible(!keepHidden);
    if (keepHidden) {
      this.setVisible(false);
    }
  }

  /**
   * Reads the keepHidden flag.
   *
   * @param _keepHidden
   */
  public boolean isKeepHidden() {
    return keepHidden;
  }

  /**
   * Gets the ThreadGroup that constructed this frame.
   *
   * @return the ThreadGroup
   */
  public ThreadGroup getConstructorThreadGroup() {
    return constructorThreadGroup;
  }

  /**
   * Creates a BufferStrategy based on the capabilites of the hardware.
   */
  protected void createBufferStrategy() {
    createBufferStrategy(2);
    strategy = this.getBufferStrategy();
  }

  /**
   * Renders the frame using the current BufferStrategy.
   */
  public void render() {
    if ( (strategy) == null) {
      createBufferStrategy();
    }
    Graphics g = strategy.getDrawGraphics();
    paintComponents(g);
    g.dispose();
    strategy.show();
  }

}
