/*
 * The org.opensourcephysics.display package contains the drawing framework
 * for the book Simulations in Physics.  This framework defines objects that
 * implement the Drawable interface and a DrawingPanel for rendering these objects.
 * Copyright (c) 2005  H. Gould, J. Tobochnik, and W. Christian.
 */
package org.opensourcephysics.display;

import org.opensourcephysics.controls.XML;

/**
 * A drawable circle that implements Measurable.
 *
 * @author Wolfgang Christian
 * @version 1.0
 */
public class MeasuredCircle extends Circle implements Measurable {

 boolean enableMeasure=true;

 /**
  * Constructs a MeasuredCircle with the given center.
  *
  * @param x the x position of the center
  * @param y the y position of the center
  */
   public MeasuredCircle (double x, double y) {
      super (x, y);
   }

  /**
   * Enables the measured flag so that this circle effects the scale of a drawing panel.
   *
   * @return minimum
   */
   public void setMeasured (boolean _enableMeasure) {
      enableMeasure = _enableMeasure;
   }

  /**
   * Determines if this circle should effect the scale of a drawing panel.
   *
   * @return minimum
   */
   public boolean isMeasured () {
      return enableMeasure;
   }

  /**
   * Implements measurable by getting the x center of the circle.
   *
   * @return minimum
   */
   public double getXMin () {
      return x;
   }

  /**
   * Implements measurable by getting the x center of the circle.
   *
   * @return maximum
   */
   public double getXMax () {
      return x;
   }

  /**
   * Implements measurable by getting the y center of the circle.
   *
   * @return minimum
   */
   public double getYMin () {
      return y;
   }

  /**
   * Implements measurable by getting the y center of the circle.
   *
   * @return maximum
   */
   public double getYMax () {
      return y;
   }

   /**
    * Gets a loader allows a Circle to be represented as XML data.
    * Objects without XML loaders cannot be saved and retrieved from an XML file.
    *
    * @return ObjectLoader
    */
   public static XML.ObjectLoader getLoader() {
     return new CircleLoader();  // use the same loader as the circle
   }

}
