/*
 * The org.opensourcephysics.display package contains the drawing framework
 * for the book Simulations in Physics.  This framework defines objects that
 * implement the Drawable interface and a DrawingPanel for rendering these objects.
 * Copyright (c) 2005  H. Gould, J. Tobochnik, and W. Christian.
 */
package org.opensourcephysics.display;

/**
 * Title:        Measurable
 * Description:  A Measurable object can return min and max values for its x and y extent.
 * This interface is used to autoscale the x and y axes on a drawing panel.
 *
 * Minimum and maximum values may NOT be valid if isMeasured returns false.  Objects that
 * store data, for example, usually return zero if data is null.
 *
 * Copyright:    Copyright (c) 2005
 * @author Wolfgang Christian
 * @version 1.0
 */
public interface Measurable extends Drawable {

  /**
   * Gets the minimum x needed to draw this object.
   * @return minimum
   */
  public double getXMin();

  /**
   * Gets the maximum x needed to draw this object.
   * @return maximum
   */
  public double getXMax();

  /**
   * Gets the minimum y needed to draw this object.
   * @return minimum
   */
  public double getYMin();

  /**
   * Gets the maximum y needed to draw this object.
   * @return minimum
   */
  public double getYMax();

  /**
   * Determines if information is available to set min/max values.
   * Objects that store data should return false if data is null.
   *
   * @return true if min/max values are valid
   */
  public boolean isMeasured();  // set to true if the measure is valid.
}
