/*
 * The org.opensourcephysics.display package contains the drawing framework
 * for the book Simulations in Physics.  This framework defines objects that
 * implement the Drawable interface and a DrawingPanel for rendering these objects.
 * Copyright (c) 2005  H. Gould, J. Tobochnik, and W. Christian.
 */
package org.opensourcephysics.display;

/**
 * Interactive defines how an object must behave so that it
 * can interact with a drawable panel.
 * @author Wolfgang Christian
 * @author Francisco Equembre
 * @version 1.0
 */
public interface Interactive extends Measurable {

   public Interactive findInteractive(DrawingPanel panel, int _xpix, int _ypix);
   public void setEnabled(boolean enabled);  // enables interactions such as dragging
   public boolean isEnabled();
   public void setXY(double x, double y);
   public void setX(double x);
   public void setY(double y);
   public double getX();
   public double getY();

}
