package org.opensourcephysics.display;

import java.io.IOException;

import javax.swing.*;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.controls.OSPLog;

public class HTMLFrame extends JFrame{

  JTextPane textPane = new JTextPane();
  JScrollPane textScroller;

  /**
   * Constructs the HTMLFrame with the given html resource.
   *
   * @param resourceName String
   */
  public HTMLFrame(String resourceName){
     this(resourceName, null);
  }

  /**
   * Constructs the HTMLFrame with the given html resource at the given location.
   * The location is relative to the given class.
   *
   * @param resourceName String
   */
   public HTMLFrame(String resourceName, Class location){
      setSize(300,300);
      textPane.setEditable(false);
      textPane.addHyperlinkListener(new HyperlinkListener(){
         public void hyperlinkUpdate(HyperlinkEvent e){
            if (e.getEventType()==HyperlinkEvent.EventType.ACTIVATED){
               try{
                  textPane.setPage(e.getURL());
               } catch (IOException ex){
               }
            }
         }
      });
      textScroller = new JScrollPane(textPane);
      setContentPane(textScroller);
      if(location==null) location=getClass();
      Resource res=null;
      try{
         res = ResourceLoader.getResource(resourceName, location);
      }catch(Exception ex){
        System.err.println(ex);
        System.err.println("Error getting html resource: "+resourceName);
        OSPLog.config("Error getting html resource: "+resourceName);
        return;
      }
      if(res==null){
         System.err.println("HTML resource not found: "+resourceName);
         OSPLog.config("HTML resource not found: "+resourceName);
         return;
      }
      try{
         textPane.setPage(res.getURL());
      } catch (IOException ex){
         System.err.println(ex);
         System.err.println("HTML resource not found: "+resourceName);
         OSPLog.config("HTML resource not found: "+resourceName);
      }
   }
}
