/*
 * The org.opensourcephysics.display package contains the drawing framework
 * for the book Simulations in Physics.  This framework defines objects that
 * implement the Drawable interface and a DrawingPanel for rendering these objects.
 * Copyright (c) 2005  H. Gould, J. Tobochnik, and W. Christian.
 */
package org.opensourcephysics.display;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Frame;

/**
 * DrawingDialog: a dialog that contains a drawing panel.
 * Copyright:    Copyright (c) 2002
 * @author       Wolfgang Christian
 * @author       Paco Esquembre
 * @version 1.0
 */
public class DrawingDialog extends OSPDialog {
   protected DrawingPanel  drawingPanel;

   /**
    * DrawingDialog constructor specifying the DrawingPanel that will be placed in
    * the center of the content pane.
    *
    * @param   DrawingPanel drawingPanel
    */
   public DrawingDialog (Frame _ownerFrame, DrawingPanel _drawingPanel) {
      super(_ownerFrame, "Drawing Dialog", false);
      if (OSPFrame.appletMode) {keepHidden = true; }
      drawingPanel = _drawingPanel;
      Container contentPane = getContentPane ();
      if (drawingPanel != null) {
         contentPane.add (drawingPanel, BorderLayout.CENTER);
      }
      setSize (300, 300);
      setVisible(true);
   }

   /**
    * Sets the drawing panel into the center of the frame.
    * @param _drawingPanel
    */
   public void setDrawingPanel (DrawingPanel _drawingPanel) {
      if (drawingPanel != null) getContentPane ().remove (drawingPanel);
      drawingPanel = _drawingPanel;
      if(drawingPanel != null) {
        getContentPane().add(drawingPanel, BorderLayout.CENTER);
      }
   }

}
