package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;

/**
 * A class to save and load DrawableShapes in an XMLControl.
 */
public class DrawableShapeLoader extends XMLLoader {

    /**
     * Saves a DrawableShape by saving the general path.
     * @param control XMLControl
     * @param obj Object
     */
    public void saveObject(XMLControl control, Object obj) {
    DrawableShape drawableShape = (DrawableShape) obj;
    control.setValue("geometry", drawableShape.shapeClass);
    control.setValue("x", drawableShape.x);
    control.setValue("y", drawableShape.y);
    control.setValue("theta", drawableShape.theta);
    control.setValue("fill color", drawableShape.color);
    control.setValue("edge color", drawableShape.edgeColor);
    Shape shape=AffineTransform.getRotateInstance(-drawableShape.theta,drawableShape.x,drawableShape.y).createTransformedShape(drawableShape.shape);
    control.setValue("general path", (GeneralPath)shape);
  }

  /**
   * Creates the DrawableShape containing a GeneralPath.
   * @param control XMLControl
   * @return Object
   */
  public Object createObject(XMLControl control) {
    return new DrawableShape(new GeneralPath(),0,0);  // default shape is a path
  }

  /**
   * Loads the DrawableShape using the path stored in the control.
   *
   * @param control XMLControl
   * @param obj Object
   * @return Object
   */
  public Object loadObject(XMLControl control, Object obj) {
    DrawableShape drawableShape = (DrawableShape) obj;
    String geometry = control.getString("geometry");
    double x = control.getDouble("x");
    double y = control.getDouble("y");
    double theta = control.getDouble("theta");
    drawableShape.shape=(Shape)control.getObject("general path");
    drawableShape.shapeClass=geometry;
    drawableShape.x=x;
    drawableShape.y=y;
    drawableShape.color = (Color) control.getObject("fill color");
    drawableShape.edgeColor = (Color) control.getObject("edge color");
    drawableShape.setTheta(theta);
    return obj;
  }

  static{  // needs this loader
  XML.setLoader(java.awt.geom.GeneralPath.class, new GeneralPathLoader());
 }

}
