/*
 * The org.opensourcephysics.display package contains the drawing framework
 * for the book Simulations in Physics.  This framework defines objects that
 * implement the Drawable interface and a DrawingPanel for rendering these objects.
 * Copyright (c) 2005  H. Gould, J. Tobochnik, and W. Christian.
 */
package org.opensourcephysics.display;

import java.awt.Graphics;

/**
 * Title:        Drawable
 * Description:  Drawable objects are rendered in a DrawingPanel.
 *
 * @author       Wolfgang Christian
 * @version 1.0
 */
public interface Drawable {

   /**
    * Draws a representation of an object in a drawing panel.
    * @param panel
    * @param g
    */
   public void draw (DrawingPanel panel, Graphics g);
}
