/*
 * The org.opensourcephysics.display package contains the drawing framework
 * for the book Simulations in Physics.  This framework defines objects that
 * implement the Drawable interface and a DrawingPanel for rendering these objects.
 * Copyright (c) 2005  H. Gould, J. Tobochnik, and W. Christian.
 */
package org.opensourcephysics.display;

import java.awt.Dimension;

/**
 * Dimensioned objects can only be drawn a certain size and therefore set the size of
 * a drawing panel's drawable area.
 *
 * The last dimensioned object to be added to a drawing panel will set the dimension
 * of the drawable area.
 *
 * @author       Wolfgang Christian
 * @version 1.0
 */
public interface Dimensioned {

   /**
    * Gets the interior dimension of the drawing panel in pixel units.
    *
    * Because this method is called before the pixel scale is set, it
    * may change the gutters and the preferred scale.
    *
    * @param the drawing panel that requested the interior
    * @return the interior dimension
    */
   public Dimension getInterior (DrawingPanel panel);
}
