package org.opensourcephysics.display;

import java.awt.Color;

import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;

/**
 * A class to save and load Circle objects in an XMLControl.
 */
public class CircleLoader extends XMLLoader {

    /**
     * Saves the Circle's data in the xml control.
     * @param control XMLControl
     * @param obj Object
     */
    public void saveObject(XMLControl control, Object obj) {
    Circle circle = (Circle) obj;
    control.setValue("x", circle.x);
    control.setValue("y", circle.y);
    control.setValue("r", circle.pixRadius);
    control.setValue("color", circle.color);
  }

  /**
   * Creates a Circle.
   * @param control XMLControl
   * @return Object
   */
  public Object createObject(XMLControl control) {
    return new Circle();
  }

  /**
   * Loads data from the xml control into the Circle object.
   * @param control XMLControl
   * @param obj Object
   * @return Object
   */
  public Object loadObject(XMLControl control, Object obj) {
    Circle circle = (Circle) obj;
    circle.x = control.getDouble("x");
    circle.y = control.getDouble("y");
    circle.color=(Color)control.getObject("color");
    return obj;
  }

}
