package org.opensourcephysics.display;

import java.awt.Color;

import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;

/**
 * A class to save and load Arrow objects in an XMLControl.
 */
public class ArrowLoader extends XMLLoader {

  /**
   * Saves the Arrow's data in the xml control.
   * @param control XMLControl
   * @param obj Object
   */
  public void saveObject(XMLControl control, Object obj) {
    Arrow arrow = (Arrow) obj;
    control.setValue("x", arrow.x);
    control.setValue("y", arrow.y);
    control.setValue("a", arrow.a);
    control.setValue("b", arrow.b);
    control.setValue("head size", (double)arrow.headSize);
    control.setValue("color", arrow.color);
  }

  /**
   * Creates an Arrow.
   * @param control XMLControl
   * @return Object
   */
  public Object createObject(XMLControl control) {
    return new Arrow(0, 0, 0, 0);
  }

  /**
   * Loads data from the xml control into the Arrow object.
   * @param control XMLControl
   * @param obj Object
   * @return Object
   */
  public Object loadObject(XMLControl control, Object obj) {
    Arrow arrow = (Arrow) obj;
    arrow.x = control.getDouble("x");
    arrow.y = control.getDouble("y");
    arrow.a = control.getDouble("a");
    arrow.b = control.getDouble("b");
    arrow.headSize=(float)control.getDouble("head size");
    arrow.color = (Color) control.getObject("color");
    return obj;
  }
}
