/*
 * The org.opensourcephysics.display package contains the drawing framework
 * for the book Simulations in Physics.  This framework defines objects that
 * implement the Drawable interface and a DrawingPanel for rendering these objects.
 * Copyright (c) 2005  H. Gould, J. Tobochnik, and W. Christian.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Graphics;

/**
 * AbstractInteractive implements common Interactive methods.
 *
 * @author Wolfgang Christian
 * @version 1.0
 */
public abstract class AbstractInteractive implements Interactive {

   public Color  color     = new Color(255,128,128,128);  // transparent light red fill color
   protected double x      = 0;
   protected double y      = 0;
   boolean enabled = true;

  /**
   * Draws the object.
   *
   * @param panel the drawing panel
   * @param g  the graphics context
   */
  public abstract void draw(DrawingPanel panel, Graphics g) ;

  /**
   * Checks to see if this object is enabled and if the pixel coordinates are inside the drawable.
   *
   * @param panel
   * @param xpix
   * @param ypix
   * @return true if the pixel coordinates are inside; false otherwise
   */
  public abstract boolean isInside (DrawingPanel panel, int xpix, int ypix);

  /**
   * Sets the enabled flag.
   * @param _enabled
   */
   public void setEnabled (boolean _enabled) {
      enabled = _enabled;
   }

   public boolean isEnabled () {
      return enabled;
   }

   /**
    * Sets the x and y coordinates.
    *
    * @param y
    */
   public void setXY (double _x, double _y) {
     x=_x;
     y=_y;
   }


   public Interactive findInteractive (DrawingPanel panel, int xpix, int ypix) {
     if(isInside(panel,  xpix, ypix) ) return this;
     else return null;
   }

   public boolean isMeasured () {
      return false;
   }

   public double getXMin () {
      return x;
   }

   public double getXMax () {
      return x;
   }

   public double getYMin () {
      return y;
   }

   public double getYMax () {
      return y;
   }

   /**
    * Gets the x coordinate.
    *
    * @return double x
    */
   public double getX () {
      return x;
   }

   /**
    * Sets the x coordinate.
    *
    * @param x
    */
   public void setX (double _x) {
     x=_x;
   }

   /**
    * Gets the y coordinate.
    *
    * @return double y
    */
   public double getY () {
      return y;
   }

   /**
    * Sets the y coordinate.
    *
    * @param y
    */
   public void setY (double _y) {
     y=_y;
   }
}
