/*
 * The org.opensourcephysics.controls package defines the framework for building
 * user interface controls for the book Simulations in Physics.
 * Copyright (c) 2005  H. Gould, J. Tobochnik, and W. Christian.
 */
package org.opensourcephysics.controls;

import java.util.Iterator;
import java.util.List;

import javax.swing.tree.DefaultMutableTreeNode;

/**
 * This is a DefaultMutableTreeNode for an XML JTree.
 *
 * @author Douglas Brown
 * @version 1.0
 */
public class XMLTreeNode extends DefaultMutableTreeNode {

  // instance fields
  private XMLProperty prop;

  /**
   * Contructs a node with an XMLProperty
   *
   * @param property the XMLProperty
   */
  public XMLTreeNode(XMLProperty property) {
    prop = property;
    setUserObject(this);
    Iterator it = property.getPropertyContent().iterator();
    while (it.hasNext()) {
      Object next = it.next();
      if (next instanceof XMLProperty) {
        XMLProperty prop = (XMLProperty)next;
        // go down one level if prop's only content is an XMLControl
        List content = prop.getPropertyContent();
        if (content.size() == 1) {
          next = content.get(0);
          if (next instanceof XMLControl) {
            prop = (XMLProperty)next;
          }
        }
        add(new XMLTreeNode(prop));
      }
    }
  }

  /**
   * Gets the XMLProperty.
   *
   * @return the XMLProperty
   */
  public XMLProperty getProperty() {
    return prop;
  }

  /**
   * This is used by the tree node to get a node label.
   *
   * @return the display name of the node
   */
  public String toString() {
    // return the child "name" property of a control element, if any
    if (prop instanceof XMLControl) {
      XMLControl control = (XMLControl) prop;
      String name = control.getString("name");
      if (name != null) return name;
    }
    return prop.getPropertyName();
  }
}
