/*
 * The org.opensourcephysics.controls package defines the framework for building
 * user interface controls for the book Simulations in Physics.
 * Copyright (c) 2005  H. Gould, J. Tobochnik, and W. Christian.
 */
package org.opensourcephysics.controls;

import java.util.List;

/**
 * This defines methods for storing data in an xml property element.
 *
 * @author Douglas Brown
 * @version 1.0
 */
public interface XMLProperty {

  /**
   * Gets the property name.
   *
   * @return a name
   */
  public String getPropertyName();

  /**
   * Gets the property type.
   *
   * @return the type
   */
  public String getPropertyType();

  /**
   * Gets the property class.
   *
   * @return the class
   */
  public Class getPropertyClass();

  /**
   * Gets the immediate parent property.
   *
   * @return the type
   */
  public XMLProperty getParentProperty();

  /**
   * Gets the level of this property relative to root.
   *
   * @return the non-negative integer level
   */
  public int getLevel();

  /**
   * Gets the property content of this property.
   *
   * @return a list of strings and XMLProperties
   */
  public List getPropertyContent();

  /**
   * Gets the named XMLControl child of this property. May return null.
   *
   * @param name the property name
   * @return the XMLControl
   */
  public XMLControl getChildControl(String name);

  /**
   * Gets the XMLControl children of this property.
   *
   * @return an array of XMLControls
   */
  public XMLControl[] getChildControls();

  /**
   * Sets the value of this property if property type is primitive or string.
   * This does nothing for other property types.
   *
   * @param stringValue the string value of a primitive or string property
   */
  public void setValue(String stringValue);

}
