/*
 * The org.opensourcephysics.controls package defines the framework for building
 * user interface controls for the book Simulations in Physics.
 * Copyright (c) 2005  H. Gould, J. Tobochnik, and W. Christian.
 */
package org.opensourcephysics.controls;

/**
 * This is an ObjectLoader implementation that attempts to create a new object
 * of class element.getObjectClass() but takes no other action. It is used as
 * the default loader and can be extended for use by particular classes.
 *
 * @author Douglas Brown
 * @version 1.0
 */
public class XMLLoader implements XML.ObjectLoader {

  /**
   * Empty method.
   *
   * @param control the control
   * @param obj the object
   */
  public void saveObject(XMLControl control, Object obj) {}

  /**
   * Creates a new object if the class type has a no-arg constructor.
   *
   * @param control the control
   * @return the new object
   * @return the loaded object
   */
  public Object createObject(XMLControl control) {
    try {
      return control.getObjectClass().newInstance();
    }
    catch (Exception ex) {
      return null;
    }
  }

  /**
   * Empty method.
   *
   * @param control the control
   * @param obj the object
   */
  public Object loadObject(XMLControl control, Object obj) {return obj;}
}
