/*
 * The org.opensourcephysics.controls package defines the framework for building
 * user interface controls for the book Simulations in Physics.
 * Copyright (c) 2005  H. Gould, J. Tobochnik, and W. Christian.
 */
package org.opensourcephysics.controls;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

/**
 * This is an ObjectLoader implementation that uses the Java XMLEncoder and
 * XMLDecoder classes to save and load data.
 *
 * @author Douglas Brown
 * @version 1.0
 */
public class XMLJavaLoader implements XML.ObjectLoader {

  private ByteArrayOutputStream out;
  private BufferedOutputStream buf;

  /**
   * Constructs the loader.
   */
  public XMLJavaLoader() {
    out = new ByteArrayOutputStream();
    buf = new BufferedOutputStream(out);
  }

  /**
   * Saves XMLEncoder data for an object in the specified XMLControl.
   *
   * @param control the control
   * @param obj the object
   */
  public void saveObject(XMLControl control, Object obj) {
//    buf.flush();
    XMLEncoder enc = new XMLEncoder(buf);
    enc.writeObject(obj);
    enc.close();
    String xml = out.toString();
    control.setValue("java_xml", xml);
  }

  /**
   * Creates a new object if the class type has a no-arg constructor.
   *
   * @param control the control
   * @return the new object
   * @return the loaded object
   */
  public Object createObject(XMLControl control) {
    String xml = control.getString("java_xml");
    InputStream in;
    try {
      in = new ByteArrayInputStream(xml.getBytes("UTF-8"));
    }
    catch (UnsupportedEncodingException ex) {
      in = new ByteArrayInputStream(xml.getBytes());
    }
    XMLDecoder dec = new XMLDecoder(new BufferedInputStream(in));
    Object obj = dec.readObject();
    dec.close();
    return obj;
  }

  /**
   * Loads an object with data from an XMLControl.
   *
   * @param control the control
   * @param obj the object
   */
  public Object loadObject(XMLControl control, Object obj) {
    return createObject(control);
  }
}
