package org.opensourcephysics.controls;

/**
 * Simulations are Animations that invoke methods before starting their animation thread and
 * after stopping their animation thread.
 *
 * @author Wolfgang Christian
 * @version 1.0
 */

public interface Simulation extends Animation{

  /**
   * Performs an action prior to starting an animation thread.
   *
   * Also invoked before a single step for consistency.
   */
  public void startRunning();

  /**
   * Performs an action after an animation thread dies.
   *
   * Also invoked after a single step for consistency.
   */
  public void stopRunning();


}
