package org.opensourcephysics.controls;
import java.awt.*;
import javax.swing.*;

/**
 * Inspects an object's state using XML.
 * @author W. Christian
 * @version 1.0
 */
public class OSPInspector {
   Object obj;
   XMLControlElement xml = new XMLControlElement();
   String shortObjectName = "null";
   Color highlightColor = new Color(224, 255, 224); // light green

   protected OSPInspector(Object obj) {
      this.obj = obj;
      String name = obj.getClass().getName();
      shortObjectName = name.substring(1+name.lastIndexOf("."));
      xml.saveObject(obj);
   }

   /**
    * Gets an  OSPInspector if the onject has an XMLLoader.
    * @param obj Object
    * @return OSPInspector
    */
   public synchronized static OSPInspector getInspector(Object obj) {
      XML.ObjectLoader loader = XML.getLoader(obj.getClass());
      if(loader.getClass()==XMLLoader.class ||  // don't use inspector for defaulf loader
         obj instanceof ControlTableModel.Expression  || // arithmetic expressions are Strings
         obj instanceof Double || obj instanceof Integer || obj instanceof Boolean ) {
         return null;  // no inspector for default loader or for wrappers for primative data types
      }
      return  new OSPInspector(obj);
   }

   /**
    * Gets the short name of the object that is being inspected.
    *
    * @return String
    */
   public String getShortObjectName() {
      return shortObjectName;
   }

   /**
    * Gets the XML string for the object being inspected.
    *
    * @return String
    */
   public String toXML(){
      return xml.toXML();
   }

   /**
    * Shows the inspector.
    *
    * @return Object the object being inspected.
    */
   public Object show(){
      xml.saveObject(obj);  // Doug:  Do we need this?
      JDialog dialog = new JDialog((java.awt.Frame)null, true);
      dialog.setContentPane(new XMLTreePanel(xml));
      dialog.setSize(new Dimension(600, 300));
      dialog.setTitle(shortObjectName+" Inspector");
      dialog.setVisible(true);
      obj= xml.loadObject(null);
      return obj;
   }
/*
   // test program
   public static void main(String[] args){
      org.opensourcephysics.display.Circle circle = new org.opensourcephysics.display.Circle();
      OSPInspector inspector = new OSPInspector(circle);
      inspector.show();
      System.out.println("x="+circle.getX());
      Color color=new Color(255,100,5);
      inspector = new OSPInspector(color);
      color=(Color)inspector.show();
      System.out.println("red="+color.getRed());
   }
*/

}
