package org.opensourcephysics.controls;

/**
 *  An OSPApplication defines a model and a control.
 *
 * @author Douglas Brown
 * @version 1.0
 */
public class OSPApplication {
  Control control;
  Object model;

  /**
   * Constructs an OSPApplication.
   *
   * @param  model
   * @param  model
   */
  public OSPApplication(Control control, Object model) {
    this.control = control;
    this.model = model;
  }

  /**
   * Returns an XML.ObjectLoader to save and load data for this object.
   *
   * @return the object loader
   */
  public static XML.ObjectLoader getLoader() {
    return new OSPAppLoader();
  }

  /**
   * A class to save and load data for OSPControls.
   */
  static class OSPAppLoader
      implements XML.ObjectLoader {
    /**
     * Saves object data to an XMLControl.
     *
     * @param xmlControl the xml control to save to
     * @param obj the object to save
     */
    public void saveObject(XMLControl xmlControl, Object obj) {
      OSPApplication app = (OSPApplication) obj;
      xmlControl.setValue("control", app.control);
      xmlControl.setValue("model", app.model);
    }

    /**
     * Creates an object using data from an XMLControl.
     *
     * @param xmlControl the xml control
     * @return the newly created object
     */
    public Object createObject(XMLControl xmlControl) {
      Object model = xmlControl.getObject("model");
      Control control = (Control) xmlControl.getObject("control");
      return new OSPApplication(control, model);
    }

    /**
     * Loads an object with data from an XMLControl.
     *
     * @param xmlControl the control
     * @param obj the object
     * @return the loaded object
     */
    public Object loadObject(XMLControl xmlControl, Object obj) {
      OSPApplication app = (OSPApplication) obj;
      XMLControlElement cControl = (XMLControlElement) xmlControl.getChildControl("control");
      if (cControl != null) {
        // autoimport data from cControl even if mismatched classes
        cControl.loadObject(app.control, true, true);
      }
      XMLControl modelControl = xmlControl.getChildControl("model");
      if (modelControl != null) {
        // autoimport data from cControl even if mismatched classes
        modelControl.loadObject(app.model);
      }
      return app;
    }
  }
}
